﻿using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// The event args used by the LocalEventService.  
    /// </summary>
    public class LocalEventArgs : EventArgs
    {
        private String _eventType = null;

        /// <summary>
        /// This string corresponds to well-known/shared EventTypes used to identify 
        /// different events published and subscribed within a local desktop application (WinFramework)
        /// or in the EHR.
        /// </summary>
        /// <example>
        /// The framewrk implements LocalSession.EventServices.RefreshRequested by sending or receiving
        /// the LocalEvent with the EventType=="REFRESH".
        /// </example>
        /// <example>
        /// The Well Child Module growth chart displays Height and Weight.  When the EHR vitals component adds
        /// new Heights and Weights it publishes a LocalEvent with an EventType PCC*MSR.  If the growth chart detects
        /// the Vitals update event it then refreshes the growth chart:
        /// <code>
        ///  void Session_ApplicationEvent(object sender, LocalEventArgs e)
        ///  {
        ///     if (this.IsVitalsUpdatedEvent(e))
        ///     {
        ///         this.RefreshAll();
        ///     }
        ///  }
        ///  
        ///  protected bool IsVitalsUpdatedEvent(LocalEventArgs anEvent)
        ///  {
        ///     return anEvent.EventType.StartsWith("PCC") &amp;&amp; anEvent.EventType.EndsWith("MSR");
        ///  }
        /// </code>
        /// </example>
        public String EventType
        {
            get { return _eventType; }
            set { _eventType = value; }
        }
        private String _details = null;

        /// <summary>
        /// This is an optional peice of data with some event-specific details.
        /// </summary>
        public String Details
        {
            get { return _details; }
            set { _details = value; }
        }


  
    }
}
